/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.MarkerUtils;
import com.aptana.debug.core.util.DebugUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.model.IJSExceptionBreakpoint;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDebugExceptionBreakpoint
extends Breakpoint
implements IJSExceptionBreakpoint {
    public JSDebugExceptionBreakpoint() {
    }

    public JSDebugExceptionBreakpoint(IResource resource, String exceptionTypeName) throws CoreException {
        this(resource, exceptionTypeName, new HashMap<String, Object>(), true);
    }

    public JSDebugExceptionBreakpoint(IUniformResource resource, String exceptionTypeName) throws CoreException {
        this(resource, exceptionTypeName, new HashMap<String, Object>(), true);
    }

    public JSDebugExceptionBreakpoint(final IResource resource, final String exceptionTypeName, final Map<String, Object> attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.aptana.debug.core.exceptionBreakpointMarker");
                JSDebugExceptionBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("com.aptana.js.debug.core.exceptionTypeName", exceptionTypeName);
                attributes.put("org.eclipse.debug.core.id", JSDebugExceptionBreakpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(Messages.JSDebugExceptionBreakpoint_JSExceptionBreakpoint_0_1, resource.getFullPath().lastSegment(), exceptionTypeName));
                JSDebugExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugExceptionBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public JSDebugExceptionBreakpoint(final IUniformResource resource, final String exceptionTypeName, final Map<String, Object> attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = MarkerUtils.createMarker((IUniformResource)resource, (Map)attributes, (String)"com.aptana.debug.core.exceptionBreakpointMarker");
                JSDebugExceptionBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("com.aptana.js.debug.core.exceptionTypeName", exceptionTypeName);
                attributes.put("org.eclipse.debug.core.id", JSDebugExceptionBreakpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(Messages.JSDebugExceptionBreakpoint_JSExceptionBreakpoint_0_1, DebugUtil.getPath((Object)resource), exceptionTypeName));
                JSDebugExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugExceptionBreakpoint.this.register(register);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JSDebugPlugin.log(Messages.JSDebugExceptionBreakpoint_BreakpointMarkerCreationFailed, e);
        }
    }

    public String getModelIdentifier() {
        return "com.aptana.js.debug.core";
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    @Override
    public String getExceptionTypeName() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("com.aptana.js.debug.core.exceptionTypeName", "");
        }
        return "";
    }
}

